unit uDM;

interface

uses
  SysUtils, Classes, DB, ADODB, Variants, Messages, Windows, Vcl.ImgList,
  Vcl.Controls;

type
  EInvoiceException = class(Exception);

  EInsertInvoiceException = class(EInvoiceException);

  EInsertRosterException = class(EInvoiceException);

  EInsertDescriptionException = class(EInvoiceException);

  EInsertConsignorException = class(EInvoiceException);

  EInsertConsigneeException = class(EInvoiceException);

  EInsertDocumentException = class(EInvoiceException);

  EUpdateDocumentException = class(EInvoiceException);

type
  TDM = class(TDataModule)
    NastrPredprQ: TADOQuery;
    MDBConnect: TADOConnection;
    DataQ: TADOQuery;
    DataQdoppick: TBooleanField;
    DataQIdDoc: TAutoIncField;
    DataQNumDoc: TIntegerField;
    DataQNumDocWithZeros: TStringField;
    DataQSeria: TStringField;
    DataQVidDoc: TWordField;
    DataQDateDoc: TDateTimeField;
    DataQDogovor: TStringField;
    DataQKodSkl: TSmallintField;
    DataQnameSkl: TStringField;
    DataQIdPredpr: TSmallintField;
    DataQnamePredpr: TStringField;
    DataQnameGrPredpr: TStringField;
    DataQidPlat: TSmallintField;
    DataQUNN: TStringField;
    DataQidGrOper: TSmallintField;
    DataQnameGrOper: TStringField;
    DataQPr_SchCenPriobr: TBooleanField;
    DataQPr_ONds: TBooleanField;
    DataQPr_SrCen: TBooleanField;
    DataQPr_SkidOv: TBooleanField;
    DataQReCountryCode: TStringField;
    DataQtotalCost: TCurrencyField;
    DataQtotalVat: TCurrencyField;
    DataQtotalExcise: TCurrencyField;
    DataQtotalCostVat: TCurrencyField;
    CreateQ: TADOQuery;
    InsertQ: TADOQuery;
    SelectDocs: TADOQuery;
    SelectDocspick: TBooleanField;
    SelectDocsdoppick: TBooleanField;
    SelectDocsIdDoc: TIntegerField;
    SelectDocsNumDoc: TIntegerField;
    SelectDocsNumDocWithZeros: TStringField;
    SelectDocsSeria: TStringField;
    SelectDocsVidDoc: TWordField;
    SelectDocsDateDoc: TDateTimeField;
    SelectDocsdogovor: TStringField;
    SelectDocsKodSkl: TSmallintField;
    SelectDocsnameSkl: TStringField;
    SelectDocsIdPredpr: TIntegerField;
    SelectDocsnamePredpr: TStringField;
    SelectDocsnameGrPredpr: TStringField;
    SelectDocsidPlat: TIntegerField;
    SelectDocsUNN: TStringField;
    SelectDocsidGrOper: TIntegerField;
    SelectDocsnameGrOper: TStringField;
    SelectDocsPr_SchCenPriobr: TBooleanField;
    SelectDocsPr_ONds: TBooleanField;
    SelectDocsPr_SrCen: TBooleanField;
    SelectDocsPr_SkidOv: TBooleanField;
    SelectDocsReCountryCode: TStringField;
    SelectDocstotalCost: TBCDField;
    SelectDocstotalExcise: TBCDField;
    SelectDocstotalVat: TBCDField;
    SelectDocstotalCostVat: TBCDField;
    SpecQ: TADOQuery;
    SpecQidPrizLog: TWordField;
    SpecQPNT: TIntegerField;
    SpecQNameVidTov: TStringField;
    SpecQCenPriobr: TBCDField;
    SpecQCenO: TBCDField;
    SpecQCenRoz: TBCDField;
    SpecQKolF: TBCDField;
    SpecQNDS: TBCDField;
    SpecQSumNDS: TBCDField;
    SpecQNacRozn: TBCDField;
    SpecQNalTr: TBCDField;
    SpecQNacObpit: TBCDField;
    SpecQNacOpt: TBCDField;
    SpecQSkidPokup: TBCDField;
    SpecQSkidOv: TBCDField;
    SpecQKolOv: TBCDField;
    SpecQBarKod: TStringField;
    SpecQKodVED: TStringField;
    SpecQusl: TBCDField;
    SpecQKodGr: TWordField;
    SpecQPriznSyria: TStringField;
    SpecQPrRazl: TStringField;
    SpecQNalProd: TBCDField;
    SpecQKolPor: TBCDField;
    SpecQPrLogBKS: TWordField;
    SpecQprice: TCurrencyField;
    SpecQcost: TCurrencyField;
    SpecQSumNDS2: TBCDField;
    SpecQSumExcise: TBCDField;
    SpecQNacPosr: TBCDField;
    UpdateDocumentQ: TADOQuery;
    MaxRosterId: TADOQuery;
    invoicesDelQ: TADOQuery;
    completedUpdQ: TADOQuery;
    documentsInsQ: TADOQuery;
    descriptionsInsQ: TADOQuery;
    consigneesInsQ: TADOQuery;
    consignorsInsQ: TADOQuery;
    rosterInsertQ: TADOQuery;
    InvInsertQ: TADOQuery;
    FreeInvNumber: TADOQuery;
    Data2Q: TADOQuery;
    invoicesSelQ: TADOQuery;
    invoicesSelQpick: TBooleanField;
    invoicesSelQfullNumber: TStringField;
    invoicesSelQinvStatus: TWordField;
    invoicesSelQinvoicesType: TStringField;
    invoicesSelQstatus: TStringField;
    invoicesSelQdateTransaction: TDateTimeField;
    invoicesSelQpName: TStringField;
    invoicesSelQrName: TStringField;
    invoicesSelQtotalCost: TBCDField;
    invoicesSelQtotalExcise: TBCDField;
    invoicesSelQtotalVat: TBCDField;
    invoicesSelQtotalCostVat: TBCDField;
    invoicesSelQdocumentType: TWordField;
    invoicesSelQidSender: TSmallintField;
    invoicesSelQsenderUNP: TStringField;
    invoicesSelQcompilingYear: TSmallintField;
    invoicesSelQnumber: TLargeintField;
    invoicesSelQproviderStatus: TWordField;
    invoicesSelQpDependentPerson: TStringField;
    invoicesSelQpResidentsOfOffshore: TStringField;
    invoicesSelQspecialDealGoods: TStringField;
    invoicesSelQpBigCompany: TStringField;
    invoicesSelQpCountryCode: TStringField;
    invoicesSelQpUNP: TStringField;
    invoicesSelQpBranchCode: TIntegerField;
    invoicesSelQpAddress: TStringField;
    invoicesSelQprincipalId: TSmallintField;
    invoicesSelQprincipalYear: TSmallintField;
    invoicesSelQprincipalNumber: TLargeintField;
    invoicesSelQprincipalDate: TDateTimeField;
    invoicesSelQpDeclaration: TStringField;
    invoicesSelQdateRelease: TDateTimeField;
    invoicesSelQdateActualExport: TDateTimeField;
    invoicesSelQpTaxesDate: TDateTimeField;
    invoicesSelQrecipientStatus: TWordField;
    invoicesSelQrDependentPerson: TStringField;
    invoicesSelQpTaxesNumber: TStringField;
    invoicesSelQrResidentsOfOffshore: TStringField;
    invoicesSelQrBigCompany: TStringField;
    invoicesSelQrCountryCode: TStringField;
    invoicesSelQrUNP: TStringField;
    invoicesSelQrBranchCode: TIntegerField;
    invoicesSelQrAddress: TStringField;
    invoicesSelQrDeclaration: TStringField;
    invoicesSelQrTaxesNumber: TStringField;
    invoicesSelQrTaxesDate: TDateTimeField;
    invoicesSelQdateImport: TDateTimeField;
    invoicesSelQcontractNumber: TStringField;
    invoicesSelQcontractDate: TDateTimeField;
    invoicesSelQvUNP: TStringField;
    invoicesSelQinvoice: TStringField;
    invoicesSelQdescription: TStringField;
    invoicesSelQfullvendor: TStringField;
    invoicesSelQvendorDate: TDateTimeField;
    invoicesSelQVendorId: TSmallintField;
    invoicesSelQvendorYear: TSmallintField;
    invoicesSelQvendorNumber: TLargeintField;
    invoicesSelQidRecipient: TIntegerField;
    consignorsSelQ: TADOQuery;
    consigneesSelQ: TADOQuery;
    documentsSelQ: TADOQuery;
    rosterSelQ: TADOQuery;
    descriptionsSelQ: TADOQuery;
    InvDeleteQ: TADOQuery;
    invoicesSelQDS: TDataSource;
    SelectDocsDS: TDataSource;
    rosterStringsDS: TDataSource;
    SearchByDocNumberDS: TDataSource;
    FreeInvNumberBuh: TADOQuery;
    PredprQBuh: TADOQuery;
    DataQBuh: TADOQuery;
    DataQBuhdoppick: TBooleanField;
    DataQBuhIdDoc: TAutoIncField;
    DataQBuhNumDoc: TStringField;
    DataQBuhNumDocWithZeros: TStringField;
    DataQBuhSeria: TStringField;
    DataQBuhVidDoc: TWordField;
    DataQBuhDateDoc: TDateTimeField;
    DataQBuhDogovor: TStringField;
    DataQBuhKodSkl: TIntegerField;
    DataQBuhnameSkl: TStringField;
    DataQBuhIdPredpr: TIntegerField;
    DataQBuhnamePredpr: TStringField;
    DataQBuhnameGrPredpr: TStringField;
    DataQBuhidPlat: TSmallintField;
    DataQBuhUNN: TStringField;
    DataQBuhidGrOper: TSmallintField;
    DataQBuhnameGrOper: TStringField;
    DataQBuhPr_ONds: TBooleanField;
    DataQBuhPr_SchCenPriobr: TBooleanField;
    DataQBuhPr_SrCen: TBooleanField;
    DataQBuhPr_SkidOv: TBooleanField;
    DataQBuhReCountryCode: TStringField;
    DataQBuhtotalCost: TCurrencyField;
    DataQBuhtotalVat: TCurrencyField;
    DataQBuhtotalExcise: TCurrencyField;
    DataQBuhtotalCostVat: TCurrencyField;
    CreateQBuh: TADOQuery;
    InsertQBuh: TADOQuery;
    SelectDocsBuh: TADOQuery;
    SelectDocsBuhpick: TBooleanField;
    SelectDocsBuhdoppick: TBooleanField;
    SelectDocsBuhIdDoc: TIntegerField;
    SelectDocsBuhNumDoc: TStringField;
    SelectDocsBuhNumDocWithZeros: TStringField;
    SelectDocsBuhSeria: TStringField;
    SelectDocsBuhVidDoc: TWordField;
    SelectDocsBuhDateDoc: TDateTimeField;
    SelectDocsBuhdogovor: TStringField;
    SelectDocsBuhKodSkl: TSmallintField;
    SelectDocsBuhnameSkl: TStringField;
    SelectDocsBuhIdPredpr: TIntegerField;
    SelectDocsBuhnamePredpr: TStringField;
    SelectDocsBuhnameGrPredpr: TStringField;
    SelectDocsBuhidPlat: TIntegerField;
    SelectDocsBuhUNN: TStringField;
    SelectDocsBuhidGrOper: TIntegerField;
    SelectDocsBuhnameGrOper: TStringField;
    SelectDocsBuhPr_SchCenPriobr: TBooleanField;
    SelectDocsBuhPr_ONds: TBooleanField;
    SelectDocsBuhPr_SrCen: TBooleanField;
    SelectDocsBuhPr_SkidOv: TBooleanField;
    SelectDocsBuhReCountryCode: TStringField;
    SelectDocsBuhtotalCost: TBCDField;
    SelectDocsBuhtotalExcise: TBCDField;
    SelectDocsBuhtotalVat: TBCDField;
    SelectDocsBuhtotalCostVat: TBCDField;
    SelectDocsBuhDS: TDataSource;
    FreeInvNumberLight: TADOQuery;
    UpdateHistoryNumberQ: TADOQuery;
    rosterStrings: TADOQuery;
    rosterStringsitemNumber: TIntegerField;
    rosterStringsname: TStringField;
    rosterStringscode: TStringField;
    rosterStringscount: TBCDField;
    rosterStringscost: TBCDField;
    rosterStringssummaExcise: TBCDField;
    rosterStringsrate: TBCDField;
    rosterStringssummaVat: TBCDField;
    rosterStringscostVat: TBCDField;
    SearchByDocNumber: TADOQuery;
    NewYearUpdate: TADOQuery;
    selectAkt: TADOQuery;
    PickChange: TADOQuery;
    PickQuery: TADOQuery;
    PickUslugi: TADOQuery;
    PredprQ: TADOQuery;
    RecipientQ: TADOQuery;
    SelectSenderList: TADOQuery;
    SelectSenderListidPredpr: TIntegerField;
    SelectSenderListUNN: TStringField;
    SelectSenderListdopUNN: TIntegerField;
    SelectInvoicesList: TADOQuery;
    SelectInvoicesListcompilingYear: TSmallintField;
    SelectInvoicesListnumber: TLargeintField;
    SelectXMLSender: TADOQuery;
    UpdateInvoiceStatus: TADOQuery;
    ChangeColl: TADOQuery;
    NastrPredprQidPlat: TSmallintField;
    NastrPredprQUNN: TStringField;
    NastrPredprQnamePredpr: TStringField;
    NastrPredprQaddress: TStringField;
    NastrPredprQPrCountryCode: TStringField;
    SelectXMLSenderidPredpr: TAutoIncField;
    ButtonsImageList_24: TImageList;
    ButtonsImageList_16: TImageList;
    CheckDocExistQ: TADOQuery;
    SpecQBuh: TADOQuery;
    SpecQBuhidPrizLog: TWordField;
    SpecQBuhPNT: TIntegerField;
    SpecQBuhNameTov: TStringField;
    SpecQBuhCenPriobr: TBCDField;
    SpecQBuhCenO: TBCDField;
    SpecQBuhCenRoz: TBCDField;
    SpecQBuhKolF: TBCDField;
    SpecQBuhNDS: TBCDField;
    SpecQBuhSumNDS: TBCDField;
    SpecQBuhNacRozn: TBCDField;
    SpecQBuhNalTr: TBCDField;
    SpecQBuhNacObpit: TBCDField;
    SpecQBuhNacOpt: TBCDField;
    SpecQBuhSkidPokup: TBCDField;
    SpecQBuhSkidOv: TBCDField;
    SpecQBuhKolOv: TBCDField;
    SpecQBuhBarKod: TStringField;
    SpecQBuhKodVED: TStringField;
    SpecQBuhusl: TBCDField;
    SpecQBuhKodGr: TWordField;
    SpecQBuhPriznSyria: TStringField;
    SpecQBuhPrRazl: TStringField;
    SpecQBuhNalProd: TBCDField;
    SpecQBuhKolPor: TIntegerField;
    SpecQBuhPrLogBKS: TWordField;
    SpecQBuhprice: TCurrencyField;
    SpecQBuhcost: TCurrencyField;
    SpecQBuhSumNDS2: TBCDField;
    SpecQBuhSumExcise: TBCDField;
    SpecQBuhNacPosr: TBCDField;
    UpdateInvDescQ: TADOQuery;
    CheckRefundQ: TADOQuery;
    UpdateInvForeignInfoQ: TADOQuery;
    invoicesSelQForeingStatus: TStringField;
    procedure DataQCalcFields(DataSet: TDataSet);
    procedure SpecQCalcFields(DataSet: TDataSet);
    procedure invoicesSelQCalcFields(DataSet: TDataSet);
    procedure DataQBuhCalcFields(DataSet: TDataSet);
    procedure DataModuleCreate(Sender: TObject);
    procedure SearchByDocNumberAfterScroll(DataSet: TDataSet);
    procedure SpecQBuhCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    MainFormHWND: HWND;
    procedure DeleteInvoice(idSender, compilingYear: Integer; number: int64);
    procedure UpdateHistoryNumber(table: string; idSender, compilingYear:
      Integer; oldNumber, newNumber: int64);
    procedure InsertInvoice(idSender, compilingYear, number, documentType,
      dateTransaction, idProvider, providerStatus, specialDealGoods,
      principalNumber, principalDate, pDeclaration, dateRelease,
      dateActualExport, pTaxesNumber, pTaxesDate, idRecipient, recipientStatus,
      rDeclaration, rTaxesNumber, rTaxesDate, dateImport, contractNumber,
      contractDate, description, totalCostVat, totalExcise, totalVat, totalCost: Variant);
    function InsertRoster(idSender, compilingYear, number, pnt, itemNumber,
      nameTov, code, code_oced, units, countTov, price, cost, summaExcise, rate,
      idRateType, summaVat, costVat: Variant): Integer;
    procedure InsertDescription(idStr, idDesc: Integer);
    procedure InsertConsignor(idSender, compilingYear, number, idPredpr: Variant);
    procedure InsertConsignee(idSender, compilingYear, number, idPredpr: Variant);
    procedure InsertDocument(idSender, compilingYear, number, code, docDate,
      blankCode, seria, docNumber, VidDoc, KodSkl, idPredpr: Variant);
    procedure UpdateDocument(idSender, compilingYear, number, code, docDate,
      blankCode, seria, docNumber, VidDoc, KodSkl, idPredpr: Variant);
    function CheckDocumentExist(idSender, compilingYear, number, docNumber,
      VidDoc, KodSkl, idPredpr: Variant): Boolean;
    procedure UpdateIvoiceDescription(table: string; idSender, compilingYear:
      Integer; number: Int64; desc: string);
    function CheckRefund(idSender, compilingYear, number: Variant): Boolean;
    procedure UpdateInvForeignInfo(table: string; idSender, compilingYear:
      Integer; number: Int64; pTaxesNumber, pTaxesDate, pDeclaration, dateRelease, dateActualExport: Variant);
  end;

var
  DM: TDM;
  SpecSum: Boolean;

implementation

uses
  UtilUnit;

{$R *.dfm}

procedure TDM.UpdateInvForeignInfo(table: string; idSender, compilingYear:
  Integer; number: Int64; pTaxesNumber, pTaxesDate, pDeclaration, dateRelease, dateActualExport: Variant);
begin
  with UpdateInvForeignInfoQ do
  begin
    SQL[1] := table;
    Parameters.ParamByName('pTaxesNumber').Value := pTaxesNumber;
    Parameters.ParamByName('pTaxesDate').Value := pTaxesDate;
    Parameters.ParamByName('pDeclaration').Value := pDeclaration;
    Parameters.ParamByName('dateRelease').Value := dateRelease;
    Parameters.ParamByName('dateActualExport').Value := dateActualExport;
    Parameters.ParamByName('sender').Value := idSender;
    Parameters.ParamByName('year').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    ExecSQL;
  end;
end;

function TDM.CheckRefund(idSender, compilingYear, number: Variant): Boolean;
begin
  with CheckRefundQ do
  begin
    Close;
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Open;

    Result := not IsEmpty;
  end;
end;

procedure TDM.UpdateIvoiceDescription(table: string; idSender, compilingYear:
  Integer; number: Int64; desc: string);
begin
  with UpdateInvDescQ do
  begin
    SQL[1] := table;
    Parameters.ParamByName('description').Value := desc;
    Parameters.ParamByName('sender').Value := idSender;
    Parameters.ParamByName('year').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    ExecSQL;
  end;
end;

procedure TDM.DeleteInvoice(idSender, compilingYear: Integer; number: int64);
begin
  with InvDeleteQ do
  begin
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    ExecSQL;
  end;
end;

procedure TDM.UpdateHistoryNumber(table: string; idSender, compilingYear:
  Integer; oldNumber, newNumber: int64);
begin
  with UpdateHistoryNumberQ do
  begin
    SQL[1] := table;
    Parameters.ParamByName('newNumber').Value := newNumber;
    Parameters.ParamByName('sender').Value := idSender;
    Parameters.ParamByName('year').Value := compilingYear;
    Parameters.ParamByName('number').Value := oldNumber;
    ExecSQL;
  end;
end;

procedure TDM.InsertInvoice(idSender, compilingYear, number, documentType,
  dateTransaction, idProvider, providerStatus, specialDealGoods, principalNumber,
  principalDate, pDeclaration, dateRelease, dateActualExport, pTaxesNumber,
  pTaxesDate, idRecipient, recipientStatus, rDeclaration, rTaxesNumber,
  rTaxesDate, dateImport, contractNumber, contractDate, description,
  totalCostVat, totalExcise, totalVat, totalCost: Variant);
begin
  with InvInsertQ do
  try
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Parameters.ParamByName('documentType').Value := documentType;
    Parameters.ParamByName('dateTransaction').Value := dateTransaction;
    Parameters.ParamByName('idProvider').Value := idProvider;
    Parameters.ParamByName('providerStatus').Value := providerStatus;
    Parameters.ParamByName('specialDealGoods').Value := specialDealGoods;
    Parameters.ParamByName('principalNumber').Value := principalNumber;
    Parameters.ParamByName('principalDate').Value := principalDate;
    Parameters.ParamByName('pDeclaration').Value := pDeclaration;
    Parameters.ParamByName('dateRelease').Value := dateRelease;
    Parameters.ParamByName('dateActualExport').Value := dateActualExport;
    Parameters.ParamByName('pTaxesNumber').Value := pTaxesNumber;
    Parameters.ParamByName('pTaxesDate').Value := pTaxesDate;
    Parameters.ParamByName('idRecipient').Value := idRecipient;
    Parameters.ParamByName('recipientStatus').Value := recipientStatus;
    Parameters.ParamByName('rDeclaration').Value := rDeclaration;
    Parameters.ParamByName('rTaxesNumber').Value := rTaxesNumber;
    Parameters.ParamByName('rTaxesDate').Value := rTaxesDate;
    Parameters.ParamByName('dateImport').Value := dateImport;
    Parameters.ParamByName('contractNumber').Value := contractNumber;
    Parameters.ParamByName('contractDate').Value := contractDate;
    Parameters.ParamByName('description').Value := description;
    Parameters.ParamByName('totalCostVat').Value := totalCostVat;
    Parameters.ParamByName('totalExcise').Value := totalExcise;
    Parameters.ParamByName('totalVat').Value := totalVat;
    Parameters.ParamByName('totalCost').Value := totalCost;
    ExecSQL;
  except
    on e: Exception do
      raise EInsertInvoiceException.Create('     Invoices  : '
        + e.Message);
  end;
end;

function TDM.InsertRoster(idSender, compilingYear, number, pnt, itemNumber,
  nameTov, code, code_oced, units, countTov, price, cost, summaExcise, rate,
  idRateType, summaVat, costVat: Variant): Integer;
begin
  with rosterInsertQ do
  try
    Close;
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Parameters.ParamByName('pnt').Value := pnt;
    Parameters.ParamByName('itemNumber').Value := itemNumber;
    Parameters.ParamByName('[name]').Value := nameTov;
    Parameters.ParamByName('code').Value := code;
    Parameters.ParamByName('code_oced').Value := code_oced;
    Parameters.ParamByName('units').Value := units;
    Parameters.ParamByName('[count]').Value := countTov;
    Parameters.ParamByName('price').Value := price;
    Parameters.ParamByName('summaExcise').Value := summaExcise;
    Parameters.ParamByName('rate').Value := rate;
    Parameters.ParamByName('idRateType').Value := idRateType;
    Parameters.ParamByName('cost').Value := cost;
    Parameters.ParamByName('summaVat').Value := summaVat;
    Parameters.ParamByName('costVat').Value := costVat;
    Open;

    Result := FieldByName('IdentValue').AsInteger;
  except
    on e: Exception do
      raise EInsertRosterException.Create('     Roster  : ' + e.Message);
  end;
end;

procedure TDM.InsertDescription(idStr, idDesc: Integer);
begin
  with descriptionsInsQ do
  try
    Parameters.ParamByName('idDesc').Value := idDesc;
    Parameters.ParamByName('idStr').Value := idStr;
    ExecSQL;
  except
    on e: Exception do
      raise EInsertDescriptionException.Create('     Description  : '
        + e.Message);
  end;
end;

procedure TDM.InsertConsignor(idSender, compilingYear, number, idPredpr: Variant);
begin
  with consignorsInsQ do
  try
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    ExecSQL;
  except
    on e: Exception do
      raise EInsertConsignorException.Create('     Consignors  : '
        + e.Message);
  end;
end;

procedure TDM.InsertConsignee(idSender, compilingYear, number, idPredpr: Variant);
begin
  with consigneesInsQ do
  try
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    ExecSQL;
  except
    on e: Exception do
      raise EInsertConsigneeException.Create('     Consignees  : '
        + e.Message);
  end;
end;

function TDM.CheckDocumentExist(idSender, compilingYear, number, docNumber,
  VidDoc, KodSkl, idPredpr: Variant): Boolean;
begin
  with CheckDocExistQ do
  begin
    Close;
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Parameters.ParamByName('docNumber').Value := docNumber;
    Parameters.ParamByName('VidDoc').Value := VidDoc;
    Parameters.ParamByName('KodSkl').Value := KodSkl;
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    Open;

    Result := not IsEmpty;
  end;
end;

procedure TDM.InsertDocument(idSender, compilingYear, number, code, docDate,
  blankCode, seria, docNumber, VidDoc, KodSkl, idPredpr: Variant);
begin
  with documentsInsQ do
  try
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Parameters.ParamByName('code').Value := code;
    Parameters.ParamByName('blankCode').Value := blankCode;
    Parameters.ParamByName('docDate').Value := docDate;
    Parameters.ParamByName('seria').Value := seria;
    Parameters.ParamByName('docNumber').Value := docNumber;
    Parameters.ParamByName('VidDoc').Value := VidDoc;
    Parameters.ParamByName('KodSkl').Value := KodSkl;
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    ExecSQL;
  except
    on e: Exception do
      raise EInsertDocumentException.Create('     Documents  : '
        + e.Message);
  end;
end;

procedure TDM.UpdateDocument(idSender, compilingYear, number, code, docDate,
  blankCode, seria, docNumber, VidDoc, KodSkl, idPredpr: Variant);
begin
  with UpdateDocumentQ do
  try
    Parameters.ParamByName('idSender').Value := idSender;
    Parameters.ParamByName('compilingYear').Value := compilingYear;
    Parameters.ParamByName('number').Value := number;
    Parameters.ParamByName('code').Value := code;
    Parameters.ParamByName('blankCode').Value := blankCode;
    Parameters.ParamByName('docDate').Value := docDate;
    Parameters.ParamByName('seria').Value := seria;
    Parameters.ParamByName('docNumber').Value := docNumber;
    Parameters.ParamByName('VidDoc').Value := VidDoc;
    Parameters.ParamByName('KodSkl').Value := KodSkl;
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    ExecSQL;
  except
    on e: Exception do
      raise EUpdateDocumentException.Create('     Documents  : '
        + e.Message);
  end;
end;

procedure TDM.DataQCalcFields(DataSet: TDataSet);
begin
  SpecSum := False;

  SpecQ.Close;
  SpecQ.Parameters.ParamByName('Pr_SrCen').Value := DataQPr_SrCen.Value;
  SpecQ.Parameters.ParamByName('IdDoc').Value := DataQIdDoc.AsInteger;
  SpecQ.Open;
  //SpecQ.First;

  DataQtotalCost.AsCurrency := 0;
  DataQtotalVat.AsCurrency := 0;
  DataQtotalExcise.AsCurrency := 0;

  while not SpecQ.Eof do
  begin
    DataQtotalCost.AsCurrency := DataQtotalCost.AsCurrency + SpecQcost.AsCurrency;
    DataQtotalVat.AsCurrency := DataQtotalVat.AsCurrency + SpecQSumNDS.AsCurrency;
    DataQtotalExcise.AsCurrency := DataQtotalExcise.AsCurrency + SpecQSumExcise.AsCurrency;
    SpecQ.Next;
  end;

  DataQtotalCostVat.AsCurrency := DataQtotalCost.AsCurrency + DataQtotalVat.AsCurrency;
  DataQtotalCost.AsCurrency := DataQtotalCost.AsCurrency; // - DataQtotalExcise.AsCurrency;
  if SpecSum then
    DataQtotalCost.AsCurrency := DataQtotalCostVat.AsCurrency;
  SpecQ.Close;
end;

procedure TDM.SpecQCalcFields(DataSet: TDataSet);
var
  C: Currency;
begin
  //  Cost
  //         
  if DataQVidDoc.AsInteger = 1 then
  begin
    if DataQPr_SrCen.AsBoolean then
      C := SpecQCenRoz.AsCurrency
    else
      C := SpecQCenO.AsCurrency;

    if DataQPr_SrCen.AsBoolean then
    begin
      if (SpecQIdPrizLog.AsInteger in [6, 41]) then
      begin
        if DataQPr_SkidOv.AsBoolean then
          SpecQcost.AsCurrency := Rounding(C * (SpecQKolF.AsCurrency - SpecQKolOv.AsCurrency)) - SpecQSumNDS2.AsCurrency
        else
          SpecQcost.AsCurrency := Rounding(C * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
      end
      else
      begin
        if DataQPr_SkidOv.AsBoolean then
          SpecQcost.AsCurrency := Rounding(C * (SpecQKolF.AsCurrency - SpecQKolOv.AsCurrency)) - SpecQSumNDS.AsCurrency
        else
          SpecQcost.AsCurrency := Rounding(C * SpecQKolF.AsCurrency) - SpecQSumNDS.AsCurrency;
      end;
    end
    else
    begin
      if (SpecQIdPrizLog.AsInteger in [6, 41]) then
      begin
        if DataQPr_SkidOv.AsBoolean then
          SpecQcost.AsCurrency := Rounding(C * (SpecQKolF.AsCurrency - SpecQKolOv.AsCurrency)) - SpecQSumNDS2.AsCurrency
        else
          SpecQcost.AsCurrency := Rounding(C * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
      end
      else
      begin
        if DataQPr_SkidOv.AsBoolean then
          SpecQcost.AsCurrency := Rounding(C * (SpecQKolF.AsCurrency - SpecQKolOv.AsCurrency))
        else
          SpecQcost.AsCurrency := Rounding(Rounding(C * (1 + SpecQNacPosr.AsCurrency
            / 100)) * SpecQKolF.AsCurrency);
      end;
    end;
    SpecQprice.AsCurrency := SpecQcost.AsCurrency / SpecQKolF.AsCurrency;
  end
  else
  begin
    if SpecQUsl.AsCurrency = 0 then
    begin
      if SpecQCenPriobr.AsCurrency = 0 then
      begin
        if DataQPr_ONds.AsBoolean then
        begin
          if SpecQIdPrizLog.AsInteger = 5 then
          begin
            if SpecQKodGr.AsInteger <> 99 then
            begin
              if SpecQSkidOv.AsCurrency <> 0 then
                SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency *
                  (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
                  / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * (SpecQKolF.AsCurrency
                  - SpecQKolOv.AsCurrency))
              else // ++
                SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency *
                  (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
                  / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
            end
            else
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency /
                100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
          end
          else
          begin
            if SpecQKodGr.AsInteger <> 99 then
            begin
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                - SpecQSkidPokup.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
                / 100) * (1 + SpecQNalTr.AsCurrency / 100)) * SpecQKolF.AsCurrency)
                - SpecQSumNDS2.AsCurrency; // 04.10.2019
              SpecSum := True;
            end
            else
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                - SpecQSkidPokup.AsCurrency / 100) * (1 + SpecQNalTr.AsCurrency
                / 100)) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
          end
        end
        else
        begin
          if SpecQPriznSyria.AsString = NullAsStringValue then
          begin
            if SpecQPrRazl.AsString <> '*' then
            begin
              if DataQPr_SrCen.AsBoolean then
                if SpecQSkidOv.AsCurrency <> 0 then
                  SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * (SpecQKolF.AsCurrency
                    - SpecQKolOv.AsCurrency))
                else if (SpecQIdPrizLog.AsInteger = 6) or (SpecQIdPrizLog.AsInteger = 41) then
                  if DataQPr_SrCen.AsBoolean then
                    SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency *
                      SpecQKolF.AsCurrency) - SpecQSumNDS.AsCurrency
                  else
                    SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency *
                      SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency
                else
                  SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * SpecQKolF.AsCurrency)
              else if SpecQIdPrizLog.AsInteger = 5 then
                SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency *
                  (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacRozn.AsCurrency
                  / 100) * (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQNDS.AsCurrency
                  / 100) * (1 + SpecQNalProd.AsCurrency / 100)) * SpecQKolF.AsCurrency)
              else
                SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency *
                  (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQNalProd.AsCurrency
                  / 100)) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
            end
            else
            begin
              if SpecQIdPrizLog.AsInteger = 5 then
              begin
                if SpecQKodGr.AsInteger <> 99 then
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacRozn.AsCurrency
                    / 100) * (1 + SpecQNacObpit.AsCurrency / 100) * (1 +
                    SpecQNDS.AsCurrency / 100) * (1 + SpecQNalProd.AsCurrency /
                    100) / SpecQKolPor.AsCurrency) * SpecQKolPor.AsCurrency * SpecQKolF.AsCurrency)
                else
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacRozn.AsCurrency
                    / 100) * (1 + SpecQNacObpit.AsCurrency / 100) * (1 +
                    SpecQNDS.AsCurrency / 100) * (1 + SpecQNalProd.AsCurrency / 100)) * SpecQKolF.AsCurrency)
              end;
              if (SpecQIdPrizLog.AsInteger = 6) or (SpecQIdPrizLog.AsInteger = 41) then
              begin
                if SpecQKodGr.AsInteger <> 99 then
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQNalProd.AsCurrency
                    / 100) / SpecQKolPor.AsCurrency) * SpecQKolPor.AsCurrency *
                    SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency
                else
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQNalProd.AsCurrency
                    / 100)) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
              end
            end
          end
          else
          begin
            if SpecQSkidOv.AsCurrency <> 0 then
              SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * (SpecQKolF.AsCurrency
                - SpecQKolOv.AsCurrency))
            else
              SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * SpecQKolF.AsCurrency);
          end
        end
      end
      else
      begin
        if not DataQPr_SchCenPriobr.AsBoolean then
          if DataQPr_ONds.AsBoolean then
          begin
            if SpecQKodGr.AsInteger <> 99 then
            begin
              if SpecQPrLogBKS.AsInteger = 0 then
                SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency *
                  (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
                  / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
              else
                SpecQcost.AsCurrency := (Rounding(Rounding(SpecQCenO.AsCurrency
                  * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
                  / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) - Rounding(Rounding
                  (SpecQCenO.AsCurrency * (1 + SpecQNalTr.AsCurrency / 100) * (1
                  + SpecQNacOpt.AsCurrency / 100) * (1 - SpecQSkidPokup.AsCurrency
                  / 100)) * SpecQNDS.AsCurrency / (100 + SpecQNDS.AsCurrency))) * SpecQKolF.AsCurrency);
            end
            else
              SpecQcost.AsCurrency := Rounding(SpecQCenO.AsCurrency * SpecQKolF.AsCurrency);
          end
          else
          begin
            if SpecQSkidOv.AsCurrency <> 0 then
              SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * (SpecQKolF.AsCurrency
                - SpecQKolOv.AsCurrency))
            else
              SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * SpecQKolF.AsCurrency)
          end
        else if DataQPr_ONds.AsBoolean then
        begin
          if SpecQKodGr.AsInteger <> 99 then
            SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenPriobr.AsCurrency
              * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
              / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
          else
            SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenPriobr.AsCurrency
              * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
              / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency);
        end
        else
        begin
          SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * SpecQKolF.AsCurrency)
        end;
      end;
    end
    else
    begin
      if SpecQCenPriobr.AsCurrency = 0 then
      begin
        if DataQPr_ONds.AsBoolean then
        begin
          if SpecQIdPrizLog.AsInteger = 5 then
          begin
            if SpecQKodGr.AsInteger <> 99 then
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency /
                100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
            else
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency /
                100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
          end;

          if (SpecQIdPrizLog.AsInteger = 6) or (SpecQIdPrizLog.AsInteger = 41) then
          begin
            if SpecQKodGr.AsInteger <> 99 then
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                - SpecQSkidPokup.AsCurrency / 100)) * (1 + SpecQNacOpt.AsCurrency
                / 100) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency
            else
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
          end
        end
        else
        begin
          if SpecQPriznSyria.AsString = NullAsStringValue then
          begin
            if SpecQPrRazl.AsString <> '*' then
            begin
              if SpecQIdPrizLog.AsInteger = 5 then
              begin
                if SpecQKodGr.AsInteger <> 99 then
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacRozn.AsCurrency
                    / 100) * (1 + SpecQNacObpit.AsCurrency / 100) * (1 +
                    SpecQNDS.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency / 100)) * SpecQKolF.AsCurrency)
                else
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacRozn.AsCurrency
                    / 100) * (1 + SpecQNacObpit.AsCurrency / 100) * (1 +
                    SpecQNDS.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency / 100)) * SpecQKolF.AsCurrency)
              end;

              if (SpecQIdPrizLog.AsInteger = 6) or (SpecQIdPrizLog.AsInteger = 41) then
              begin
                if SpecQKodGr.AsInteger <> 99 then
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency
                    / 100)) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency
                else
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency
                    / 100)) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
              end
            end
            else
            begin
              if SpecQIdPrizLog.AsInteger = 5 then
              begin
                if SpecQKodGr.AsInteger <> 99 then
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacRozn.AsCurrency
                    / 100) * (1 + SpecQNacObpit.AsCurrency / 100) * (1 +
                    SpecQNDS.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency / 100)
                    / SpecQKolPor.AsCurrency) * SpecQKolPor.AsCurrency * SpecQKolF.AsCurrency)
                else
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacRozn.AsCurrency
                    / 100) * (1 + SpecQNacObpit.AsCurrency / 100) * (1 +
                    SpecQNDS.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency / 100)) * SpecQKolF.AsCurrency)
              end;

              if (SpecQIdPrizLog.AsInteger = 6) or (SpecQIdPrizLog.AsInteger = 41) then
              begin
                if SpecQKodGr.AsInteger <> 99 then
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency
                    / 100) / SpecQKolPor.AsCurrency) * SpecQKolPor.AsCurrency *
                    SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency
                else
                  SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency
                    * (1 + SpecQNacObpit.AsCurrency / 100) * (1 + SpecQUsl.AsCurrency
                    / 100)) * SpecQKolF.AsCurrency) - SpecQSumNDS2.AsCurrency;
              end
            end
          end
          else
          begin
            SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * SpecQKolF.AsCurrency);
          end
        end
      end
      else
      begin
        if not DataQPr_SchCenPriobr.AsBoolean then
          if DataQPr_ONds.AsBoolean then
          begin
            if SpecQKodGr.AsInteger <> 99 then
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency /
                100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
            else
              SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenO.AsCurrency * (1
                + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency /
                100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
          end
          else
          begin
            SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * SpecQKolF.AsCurrency)

          end
        else if DataQPr_ONds.AsBoolean then
        begin
          if SpecQKodGr.AsInteger <> 99 then
            SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenPriobr.AsCurrency
              * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
              / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
          else
            SpecQcost.AsCurrency := Rounding(Rounding(SpecQCenPriobr.AsCurrency
              * (1 + SpecQNalTr.AsCurrency / 100) * (1 + SpecQNacOpt.AsCurrency
              / 100) * (1 - SpecQSkidPokup.AsCurrency / 100)) * SpecQKolF.AsCurrency)
        end
        else
        begin
          SpecQcost.AsCurrency := Rounding(SpecQCenRoz.AsCurrency * SpecQKolF.AsCurrency);
        end;
      end;
    end;

    if (DataQPr_SrCen.AsBoolean) and (SpecQidPrizLog.AsInteger = 5) then
      SpecQcost.AsCurrency := SpecQcost.AsCurrency - SpecQSumNDS.AsCurrency;

    if SpecQKolF.AsCurrency = 0 then
      MessageBox(Self.MainFormHWND, PChar('      '
        + DataQNumDoc.AsString), PChar(''), 0);

    if SpecSum then
      SpecQprice.AsCurrency := (SpecQcost.AsCurrency + SpecQSumNDS.AsCurrency) / SpecQKolF.AsCurrency
    else
      SpecQprice.AsCurrency := SpecQcost.AsCurrency / SpecQKolF.AsCurrency;
  end;
end;

procedure TDM.invoicesSelQCalcFields(DataSet: TDataSet);
begin
  invoicesSelQfullNumber.AsString := invoicesSelQsenderUNP.AsString + '-' +
    invoicesSelQcompilingYear.AsString + '-' + IntToStrWithZeros(invoicesSelQnumber.AsLargeInt, 10);

  if Length(invoicesSelQvendorNumber.AsString) <> 0 then
    invoicesSelQfullvendor.AsString := invoicesSelQvUNP.AsString + '-' +
      invoicesSelQvendorYear.AsString + '-' + IntToStrWithZeros(invoicesSelQvendorNumber.AsLargeInt, 10);

  invoicesSelQinvoicesType.AsString := GetInvoiceTypeById(invoicesSelQdocumentType.AsInteger);
  invoicesSelQstatus.AsString := GetStatusTextById(invoicesSelQinvStatus.AsInteger);

  if invoicesSelQpCountryCode.AsString <> invoicesSelQrCountryCode.AsString then
    if (Length(invoicesSelQpTaxesNumber.AsString) > 0) or (Length(invoicesSelQpDeclaration.AsString) > 0) then
      invoicesSelQForeingStatus.AsString := ''
    else
      invoicesSelQForeingStatus.AsString := ' '
  else
    invoicesSelQForeingStatus.AsString := ' ';
end;

procedure TDM.DataQBuhCalcFields(DataSet: TDataSet);
begin
  //11.10.2019
  SpecSum := False;

  SpecQBuh.Close;
  SpecQBuh.Parameters.ParamByName('Pr_SrCen').Value := DataQBuhPr_SrCen.Value;
  //21.10.2019  SpecQBuh -      
  SpecQBuh.Parameters.ParamByName('Pr_ONds').Value := DataQBuhPr_ONds.Value;
  SpecQBuh.Parameters.ParamByName('IdDoc').Value := DataQBuhIdDoc.AsInteger;
  SpecQBuh.Open;
   //SpecQ.First;

  DataQBuhtotalCost.AsCurrency := 0;
  DataQBuhtotalVat.AsCurrency := 0;
  DataQBuhtotalExcise.AsCurrency := 0;

  while not SpecQBuh.Eof do
  begin
    DataQBuhtotalCost.AsCurrency := DataQBuhtotalCost.AsCurrency + SpecQBuhcost.AsCurrency;
    DataQBuhtotalVat.AsCurrency := DataQBuhtotalVat.AsCurrency + SpecQBuhSumNDS.AsCurrency;
    DataQBuhtotalExcise.AsCurrency := DataQBuhtotalExcise.AsCurrency + SpecQBuhSumExcise.AsCurrency;
    SpecQBuh.Next;
  end;

  DataQBuhtotalCostVat.AsCurrency := DataQBuhtotalCost.AsCurrency + DataQBuhtotalVat.AsCurrency;
  DataQBuhtotalCost.AsCurrency := DataQBuhtotalCost.AsCurrency; // - DataQtotalExcise.AsCurrency;
//   11.10.2019
  if SpecSum then
    DataQBuhtotalCost.AsCurrency := DataQBuhtotalCostVat.AsCurrency;
//
  SpecQBuh.Close;
end;

procedure TDM.SpecQBuhCalcFields(DataSet: TDataSet);
var
  C: Currency;
begin
  //  Cost
  //         
  if DataQBuhVidDoc.AsInteger = 9 then
  begin
    if DataQBuhPr_SrCen.AsBoolean then
      if DataQBuhPr_ONds.AsBoolean then         //04.08.2017
        C := SpecQBuhCenO.AsCurrency
      else
        C := SpecQBuhCenRoz.AsCurrency
    else
      C := SpecQBuhCenO.AsCurrency;

    if DataQBuhPr_SrCen.AsBoolean then   //   
    begin
      if DataQBuhPr_ONds.AsBoolean then              //04.08.2017
      begin
        if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
        begin
          if DataQBuhPr_SkidOv.AsBoolean then
            SpecQBuhcost.AsCurrency := Rounding(C * (SpecQBuhKolF.AsCurrency -
              SpecQBuhKolOv.AsCurrency))  //-SpecQBuhSumNDS2.AsCurrency
          else
            SpecQBuhcost.AsCurrency := Rounding(C * SpecQBuhKolF.AsCurrency);  //-SpecQBuhSumNDS2.AsCurrency;
        end
        else
        begin
          if DataQBuhPr_SkidOv.AsBoolean then
            SpecQBuhcost.AsCurrency := Rounding(C * (SpecQBuhKolF.AsCurrency -
              SpecQBuhKolOv.AsCurrency)) //-SpecQBuhSumNDS.AsCurrency
          else
            SpecQBuhcost.AsCurrency := Rounding(C * SpecQBuhKolF.AsCurrency);  //-SpecQBuhSumNDS.AsCurrency;
        end;                                                  //04.08.2017
      end
      else
      begin
        if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
        begin
          if DataQBuhPr_SkidOv.AsBoolean then
            SpecQBuhcost.AsCurrency := Rounding(C * (SpecQBuhKolF.AsCurrency -
              SpecQBuhKolOv.AsCurrency)) - SpecQBuhSumNDS2.AsCurrency
          else
            SpecQBuhcost.AsCurrency := Rounding(C * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency;
        end
        else
        begin
          if DataQBuhPr_SkidOv.AsBoolean then
            SpecQBuhcost.AsCurrency := Rounding(C * (SpecQBuhKolF.AsCurrency -
              SpecQBuhKolOv.AsCurrency)) - SpecQBuhSumNDS.AsCurrency
          else
            SpecQBuhcost.AsCurrency := Rounding(C * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS.AsCurrency;
        end;
      end;
    end
    else      //   
    begin
      if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
      begin
        if DataQBuhPr_SkidOv.AsBoolean then
          SpecQBuhcost.AsCurrency := Rounding(C * (SpecQBuhKolF.AsCurrency -
            SpecQBuhKolOv.AsCurrency)) - SpecQBuhSumNDS2.AsCurrency
        else
          SpecQBuhcost.AsCurrency := Rounding(C * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency;
      end
      else
      begin
        if DataQBuhPr_SkidOv.AsBoolean then
          SpecQBuhcost.AsCurrency := Rounding(C * (SpecQBuhKolF.AsCurrency - SpecQBuhKolOv.AsCurrency))
        else
          SpecQBuhcost.AsCurrency := Rounding(Rounding(C * (1 + SpecQBuhNacPosr.AsCurrency
            / 100)) * SpecQBuhKolF.AsCurrency);
      end;
    end;
    SpecQBuhprice.AsCurrency := SpecQBuhcost.AsCurrency / SpecQBuhKolF.AsCurrency;
  end
  else
  begin // 10
    if SpecQBuhUsl.AsCurrency = 0 then
    begin
      if (SpecQBuhCenPriobr.AsCurrency = 0) or (SpecQBuhCenPriobr.AsCurrency = SpecQBuhCenO.AsCurrency) then
      begin
        if DataQBuhPr_ONds.AsBoolean then
        begin
          if SpecQBuhIdPrizLog.AsInteger = 5 then
          begin
            if SpecQBuhKodGr.AsInteger <> 99 then
            begin
              if SpecQBuhSkidOv.AsCurrency <> 0 then
                SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                  * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                  / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * (SpecQBuhKolF.AsCurrency
                  - SpecQBuhKolOv.AsCurrency))
              else
                SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                  * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                  / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
            end
            else
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
          end
          else
          begin   //IdPrizLog<>5
            //11.11.2019
            if SpecQBuhIdPrizLog.AsInteger = 41 then
              SpecSum := true
            else
              SpecSum := false;
            //11.11.2019

            if SpecQBuhKodGr.AsInteger <> 99 then
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 - SpecQBuhSkidPokup.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                / 100) * (1 + SpecQBuhNalTr.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency
            else
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 - SpecQBuhSkidPokup.AsCurrency / 100) * (1 + SpecQBuhNalTr.AsCurrency
                / 100)) * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency;
          end
        end
        else
        begin  //Pr_ONDS=0
          if SpecQBuhPriznSyria.AsString = NullAsStringValue then
          begin
            if SpecQBuhPrRazl.AsString <> '*' then
            begin
              if DataQBuhPr_SrCen.AsBoolean then
                if SpecQBuhSkidOv.AsCurrency <> 0 then
                  SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency
                    * (SpecQBuhKolF.AsCurrency - SpecQBuhKolOv.AsCurrency))
                else if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
                begin
                  //11.10.2019
                  if SpecQBuhIdPrizLog.AsInteger = 41 then
                    SpecSum := true
                  else
                    SpecSum := false;
                  //
                  if DataQBuhPr_SrCen.AsBoolean then
                    SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency
                      * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS.AsCurrency
                  else
                    SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency
                      * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency           //  ()
                end
                else
                  SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * SpecQBuhKolF.AsCurrency)
              else if SpecQBuhIdPrizLog.AsInteger = 5 then
                 //Pr_ONDS=1
                SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                  * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacRozn.AsCurrency
                  / 100) * (1 + SpecQBuhNacObpit.AsCurrency / 100) *                           //(1+SpecQBuhNDS.AsCurrency/100)*
                  (1 + SpecQBuhNalProd.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
              else
              begin
                if SpecQBuhIdPrizLog.AsInteger = 41 then
                  SpecSum := true;
                SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                  * (1 + SpecQBuhNacObpit.AsCurrency / 100) * (1 +
                  SpecQBuhNalProd.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency;
              end;
            end
            else
            begin
              if SpecQBuhIdPrizLog.AsInteger = 5 then
              begin
                if SpecQBuhKodGr.AsInteger <> 99 then
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 +
                    SpecQBuhNacRozn.AsCurrency / 100) * (1 + SpecQBuhNacObpit.AsCurrency
                    / 100) *                           //(1+SpecQBuhNDS.AsCurrency/100)*
                    (1 + SpecQBuhNalProd.AsCurrency / 100) / SpecQBuhKolPor.AsCurrency)
                    * SpecQBuhKolPor.AsCurrency * SpecQBuhKolF.AsCurrency)
                else
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 +
                    SpecQBuhNacRozn.AsCurrency / 100) * (1 + SpecQBuhNacObpit.AsCurrency
                    / 100) *                           //(1+SpecQBuhNDS.AsCurrency/100)*
                    (1 + SpecQBuhNalProd.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
              end;

              if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
              begin
                //11.11.2019
                if SpecQBuhIdPrizLog.AsInteger = 41 then
                  SpecSum := true
                else
                  SpecSum := false;
                //11.11.2019
                if SpecQBuhKodGr.AsInteger <> 99 then
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNacObpit.AsCurrency / 100) * (1 +
                    SpecQBuhNalProd.AsCurrency / 100) / SpecQBuhKolPor.AsCurrency)
                    * SpecQBuhKolPor.AsCurrency * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency
                else
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNacObpit.AsCurrency / 100) * (1 +
                    SpecQBuhNalProd.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
                    - SpecQBuhSumNDS2.AsCurrency;
              end
            end
          end
          else
          begin
            if SpecQBuhSkidOv.AsCurrency <> 0 then
              SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * (SpecQBuhKolF.AsCurrency
                - SpecQBuhKolOv.AsCurrency))
            else
              SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * SpecQBuhKolF.AsCurrency);
          end
        end
      end
      else
      begin
        if not DataQBuhPr_SchCenPriobr.AsBoolean then
          if DataQBuhPr_ONds.AsBoolean then
          begin
            if SpecQBuhKodGr.AsInteger <> 99 then
            begin
              if SpecQBuhPrLogBKS.AsInteger = 0 then
                SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                  * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                  / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
              else
                SpecQBuhcost.AsCurrency := (Rounding(Rounding(SpecQBuhCenO.AsCurrency
                  * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                  / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) - Rounding(Rounding
                  (SpecQBuhCenO.AsCurrency * (1 + SpecQBuhNalTr.AsCurrency / 100)
                  * (1 + SpecQBuhNacOpt.AsCurrency / 100) * (1 -
                  SpecQBuhSkidPokup.AsCurrency / 100)))) * // SpecQBuhNDS.AsCurrency/(100+SpecQBuhNDS.AsCurrency)))*
                  SpecQBuhKolF.AsCurrency);
            end
            else
              SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenO.AsCurrency * SpecQBuhKolF.AsCurrency);
          end
          else
          begin
            if SpecQBuhSkidOv.AsCurrency <> 0 then
              SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * (SpecQBuhKolF.AsCurrency
                - SpecQBuhKolOv.AsCurrency))
            else
              SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * SpecQBuhKolF.AsCurrency)
          end
        else if DataQBuhPr_ONds.AsBoolean then
        begin
          if SpecQBuhKodGr.AsInteger <> 99 then
            SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenPriobr.AsCurrency
              * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
              / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
          else
            SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenPriobr.AsCurrency
              * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
              / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency);
        end
        else
        begin
          SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * SpecQBuhKolF.AsCurrency)
        end;
      end;
    end
    else
    begin
      if SpecQBuhCenPriobr.AsCurrency = 0 then
      begin
        if DataQBuhPr_ONds.AsBoolean then
        begin
          if SpecQBuhIdPrizLog.AsInteger = 5 then
          begin
            if SpecQBuhKodGr.AsInteger <> 99 then
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
            else
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
          end;

          if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
          begin
            if SpecQBuhKodGr.AsInteger <> 99 then
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * (1 +
                SpecQBuhNacOpt.AsCurrency / 100) * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency
            else
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
                - SpecQBuhSumNDS2.AsCurrency;
          end;
        end
        else
        begin
          if SpecQBuhPriznSyria.AsString = NullAsStringValue then
          begin
            if SpecQBuhPrRazl.AsString <> '*' then
            begin
              if SpecQBuhIdPrizLog.AsInteger = 5 then
              begin
                if SpecQBuhKodGr.AsInteger <> 99 then
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 +
                    SpecQBuhNacRozn.AsCurrency / 100) * (1 + SpecQBuhNacObpit.AsCurrency
                    / 100) *                           //(1+SpecQBuhNDS.AsCurrency/100)*
                    (1 + SpecQBuhUsl.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
                else
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 +
                    SpecQBuhNacRozn.AsCurrency / 100) * (1 + SpecQBuhNacObpit.AsCurrency
                    / 100) *                           //(1+SpecQBuhNDS.AsCurrency/100)*
                    (1 + SpecQBuhUsl.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
              end;
              if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
              begin

                //11.11.2019
                if SpecQBuhIdPrizLog.AsInteger = 41 then
                  SpecSum := true
                else
                  SpecSum := false;
                //11.11.2019

                if SpecQBuhKodGr.AsInteger <> 99 then
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNacObpit.AsCurrency / 100) * (1 + SpecQBuhUsl.AsCurrency
                    / 100)) * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency
                else
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNacObpit.AsCurrency / 100) * (1 + SpecQBuhUsl.AsCurrency
                    / 100)) * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency;
              end
            end
            else
            begin
              if SpecQBuhIdPrizLog.AsInteger = 5 then
              begin
                if SpecQBuhKodGr.AsInteger <> 99 then
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 +
                    SpecQBuhNacRozn.AsCurrency / 100) * (1 + SpecQBuhNacObpit.AsCurrency
                    / 100) *                           //(1+SpecQBuhNDS.AsCurrency/100)*
                    (1 + SpecQBuhUsl.AsCurrency / 100) / SpecQBuhKolPor.AsCurrency)
                    * SpecQBuhKolPor.AsCurrency * SpecQBuhKolF.AsCurrency)
                else
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 +
                    SpecQBuhNacRozn.AsCurrency / 100) * (1 + SpecQBuhNacObpit.AsCurrency
                    / 100) *                           //(1+SpecQBuhNDS.AsCurrency/100)*
                    (1 + SpecQBuhUsl.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
              end;

              if (SpecQBuhIdPrizLog.AsInteger = 6) or (SpecQBuhIdPrizLog.AsInteger = 41) then
              begin
                //11.11.2019
                if SpecQBuhIdPrizLog.AsInteger = 41 then
                  SpecSum := true
                else
                  SpecSum := false;
                //11.11.2019
                if SpecQBuhKodGr.AsInteger <> 99 then
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNacObpit.AsCurrency / 100) * (1 + SpecQBuhUsl.AsCurrency
                    / 100) / SpecQBuhKolPor.AsCurrency) * SpecQBuhKolPor.AsCurrency
                    * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency
                else
                  SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                    * (1 + SpecQBuhNacObpit.AsCurrency / 100) * (1 + SpecQBuhUsl.AsCurrency
                    / 100)) * SpecQBuhKolF.AsCurrency) - SpecQBuhSumNDS2.AsCurrency;
              end
            end
          end
          else
          begin
            SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * SpecQBuhKolF.AsCurrency);
          end
        end
      end
      else
      begin
        if not DataQBuhPr_SchCenPriobr.AsBoolean then
          if DataQBuhPr_ONds.AsBoolean then
          begin
            if SpecQBuhKodGr.AsInteger <> 99 then
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
            else
              SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenO.AsCurrency
                * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
                / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
          end
          else
          begin
            SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * SpecQBuhKolF.AsCurrency)
          end
        else if DataQBuhPr_ONds.AsBoolean then
        begin
          if SpecQBuhKodGr.AsInteger <> 99 then
            SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenPriobr.AsCurrency
              * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
              / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
          else
            SpecQBuhcost.AsCurrency := Rounding(Rounding(SpecQBuhCenPriobr.AsCurrency
              * (1 + SpecQBuhNalTr.AsCurrency / 100) * (1 + SpecQBuhNacOpt.AsCurrency
              / 100) * (1 - SpecQBuhSkidPokup.AsCurrency / 100)) * SpecQBuhKolF.AsCurrency)
        end
        else
        begin
          SpecQBuhcost.AsCurrency := Rounding(SpecQBuhCenRoz.AsCurrency * SpecQBuhKolF.AsCurrency);
        end;
      end;
    end;

    if SpecQBuhKolF.AsCurrency = 0 then
      MessageBox(Self.MainFormHWND, PChar('      '
        + DataQBuhNumDoc.AsString), PChar(''), 0);

    if (DataQBuhPr_SrCen.AsBoolean) and not (DataQBuhPr_ONDS.AsBoolean) then
      if (SpecQBuhidPrizLog.AsInteger = 5) then
        SpecQBuhcost.AsCurrency := SpecQBuhcost.AsCurrency - SpecQBuhSumNDS.AsCurrency;

    // 11.10.2019
    if SpecSum then
      SpecQBuhprice.AsCurrency := (SpecQBuhcost.AsCurrency + SpecQBuhSumNDS.AsCurrency) / SpecQBuhKolF.AsCurrency
    else//
      SpecQBuhprice.AsCurrency := SpecQBuhcost.AsCurrency / SpecQBuhKolF.AsCurrency;
  end;
end;

procedure TDM.DataModuleCreate(Sender: TObject);
var
  F: TextFile;
  S: string;
begin
  AssignFile(F, extractfilepath(paramstr(0)) + 'MdbConnect.ini');
  Reset(F);
  Read(F, S);
  CloseFile(F);

  MDBConnect.Close;
  MDBConnect.ConnectionString := S;
  MDBConnect.Open;

  ChangeColl.ExecSQL;
  invoicesDelQ.ExecSQL;

  NastrPredprQ.Close;
  NastrPredprQ.Open;
  //16.10.2019
  PredprQBuh.Close;
  PredprQBuh.Open;
  //
end;

procedure TDM.SearchByDocNumberAfterScroll(DataSet: TDataSet);
begin
  invoicesSelQ.Locate('number', SearchByDocNumber.FieldByName('number').AsVariant, [loCaseInsensitive]);
end;

end.

